IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_TRANSF_AGENDAS_PROD]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_TRANSF_AGENDAS_PROD]

GO
CREATE PROCEDURE [dbo].[P_EST_PROD_TRANSF_AGENDAS_PROD] (@CD_EMP		INT   = 1, 
														@CD_DEPOSITO	INT   = 0, 
														@DIA_SEMANA		INT   = 0) AS

SET NOCOUNT ON;

/****************************************************************************************************/
	IF NOT EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_MEDIAF_PARAMS')
	BEGIN 
		Print 'Tabela do ressuprimento nao encontrada'
		RETURN;
	END
	IF NOT EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_PRODUTOS')
	BEGIN 
		Print 'Tabela de produtos ressuprimento nao encontrada'
		RETURN;
	END
 
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_AGENDAS')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AGENDAS
	END
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_AGENDAMENTO_AUX')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AGENDAMENTO_AUX
	END
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_AGENDAS_PROD')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AGENDAS_PROD
	END
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_AGENDAMENTO')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AGENDAMENTO
	END		
/**************************************************************************************************/
INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
				,'Criando tabelas de agendamento do ressuprimento '
				,'INFORMACAO'
				, 51
				,'P_EST_PROD_TRANSF_AGENDAMENTO'
				,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
				,'RESSUPRIMENTO');

	CREATE TABLE EST_PROD_TRANSF_AGENDAMENTO ( CD_EMP		INT,
												CD_FILIAL			INT,
												CD_PROD				INT,
												PARAM_ADICIONAL		 MONEY,
												FLAG_NAO_ENVIAR_PBM  INT, 
												DIARIO				 tinyint,
												PRIMARY KEY (CD_PROD, CD_FILIAL));

	CREATE TABLE EST_PROD_TRANSF_AGENDAS (CD_CTR_AGENDA INT, PRIMARY KEY (CD_CTR_AGENDA));
	CREATE TABLE EST_PROD_TRANSF_AGENDAS_PROD (CD_CTR_AGENDA INT,CD_PROD INT, TP_NIVEL TINYINT)
	CREATE TABLE EST_PROD_TRANSF_AGENDAMENTO_AUX (CD_EMP INT, CD_FILIAL INT, CD_PROD INT,
													PARAM_ADICIONAL TINYINT, FLAG_NAO_ENVIAR_PBM TINYINT, 
													AGD_DIARIO TINYINT) 

/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
				,'Insere agendamento - EST_PROD_RESSUP_AGENDAMENTO'
				,'INSERT'
				, 74
				,'P_EST_PROD_TRANSF_AGENDAS_PROD'
				,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
				,'RESSUPRIMENTO');

	INSERT INTO EST_PROD_TRANSF_AGENDAMENTO  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,DIARIO)
	SELECT 
		A.CD_EMP,
		P.CD_FILIAL,
		W.CD_PROD, 
		MAX(A.LEAD_TIME + A.PARAM_EST) PARAM_ADD,
		MAX(ISNULL(A.FLAG_NAO_ENVIAR_PBM,0)),
		MAX(CASE WHEN ISNULL(A.NAO_CONSID_ESEG,0)=0 THEN 5 ELSE 1 END)--5 DIARIO -- se for agendamento antigo considera Eseg
	FROM  
		EST_PROD_RESSUP_AGENDAMENTO A
		INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL p on
		A.CD_EMP		= P.CD_EMP AND
		A.CD_AGD_RESSUP  = P.CD_AGD_RESSUP
		INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC f on
		A.CD_EMP		= F.CD_EMP AND
		A.CD_AGD_RESSUP  = F.CD_AGD_RESSUP
		INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_ARV_MERC_LINHA l on
		A.CD_EMP		= L.CD_EMP AND
		A.CD_AGD_RESSUP  = L.CD_AGD_RESSUP 
		INNER JOIN EST_PROD Y on 
		F.CD_FABRIC  = Y.CD_FABRIC 
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA W on
		L.CD_EMP			 = W.CD_EMP AND
		L.CD_ARV_MERC_LINHA  = W.CD_ARV_MERC_LINHA AND
		Y.CD_PROD			 = W.CD_PROD
	WHERE
		A.CD_EMP	= @CD_EMP
		AND A.CD_FILIAL_DEPO	= @CD_DEPOSITO 
		AND	(CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
				WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
				WHEN @DIA_SEMANA =3 THEN A.TERCA  
				WHEN @DIA_SEMANA =4 THEN A.QUARTA
				WHEN @DIA_SEMANA =5 THEN A.QUINTA  
				WHEN @DIA_SEMANA =6 THEN A.SEXTA  
				WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1 
	GROUP BY 
		A.CD_EMP,
		P.CD_FILIAL,
		W.CD_PROD;    

/**************************************************************************************************/

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Carrega as agendas do agendamento novo - EST_PROD_AGENDA_COMPRA'
		,'INSERT'
		, 126
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

	INSERT INTO EST_PROD_TRANSF_AGENDAS
	SELECT  A.CD_CTR_AGENDA 
	FROM 
		EST_PROD_AGENDA_COMPRA A 
	WHERE
		A.TIPO_AGENDA= 2
		and STS_AGENDA=0 
		AND A.CD_EMP=1
		AND A.CD_FILIAL_DEPO = @CD_DEPOSITO
		AND (CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
				WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
				WHEN @DIA_SEMANA =3 THEN A.TERCA  
				WHEN @DIA_SEMANA =4 THEN A.QUARTA
				WHEN @DIA_SEMANA =5 THEN A.QUINTA  
				WHEN @DIA_SEMANA =6 THEN A.SEXTA  
				WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1 
/***********************************************************************************************/
-- Carga dos produtos que participam da agenda. Agendamento novo
/***********************************************************************************************/
  
  
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Carga dos produtos que participam da agenda'
		,'INSERT'
		, 155
		,'P_EST_PROD_TRANSF_AGENDAS_PROD'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

	--Produtos da agenda
	INSERT INTO EST_PROD_TRANSF_AGENDAS_PROD 
	SELECT 
		P.CD_CTR_AGENDA,		
		P.CD_PROD,
		1 TP_NIVEL
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_PROD p
		inner join EST_PROD_TRANSF_AGENDAS a on 
			p.CD_CTR_AGENDA= A.CD_CTR_AGENDA
	WHERE
		P.CD_EMP = @CD_EMP ;
		 
	--Linhas
	INSERT INTO EST_PROD_TRANSF_AGENDAS_PROD 
	SELECT DISTINCT 
		L.CD_CTR_AGENDA,
		A.CD_PROD,
		3 TP_NIVEL
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_LINHA L
		JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
		L.CD_EMP = A.CD_EMP AND
		L.CD_ARV_MERC_LINHA= A.CD_ARV_MERC_LINHA  
		inner join EST_PROD_TRANSF_AGENDAS ag on 
			l.CD_CTR_AGENDA= Ag.CD_CTR_AGENDA 		
	WHERE
		l.CD_EMP = @CD_EMP ;
	
	INSERT INTO EST_PROD_TRANSF_AGENDAS_PROD	
	SELECT DISTINCT
		C.CD_CTR_AGENDA,		
		A.CD_PROD ,
		4 TP_NIVEL
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_CATEGORIA C
		JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
		C.CD_EMP = A.CD_EMP AND
		C.CD_ARV_MERC_CATEG= A.CD_ARV_MERC_CATEG 
		inner join EST_PROD_TRANSF_AGENDAS ag on 
		c.CD_CTR_AGENDA= Ag.CD_CTR_AGENDA 
	WHERE
		A.CD_EMP = @CD_EMP  ;  
			 
	--Fabricantes
	INSERT INTO EST_PROD_TRANSF_AGENDAS_PROD 
	SELECT DISTINCT  
		f.CD_CTR_AGENDA,
		P.CD_PROD,
		5 TP_NIVEL
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_PROD_FABRIC F
		JOIN EST_PROD P ON 
		F.CD_EMP = P.CD_EMP AND
		F.CD_FABRIC = P.CD_FABRIC
		inner join EST_PROD_TRANSF_AGENDAS ag on 
			f.CD_CTR_AGENDA= Ag.CD_CTR_AGENDA
	WHERE
		P.CD_EMP = @CD_EMP;		   

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Cria index para performance - IX_EST_PROD_TRANSF_AGENDAS_PROD_CD_CTR_AGENDA'
		,'CREATE'
		, 226
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');
CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_AGENDAS_PROD_CD_CTR_AGENDA
	ON [dbo].[EST_PROD_TRANSF_AGENDAS_PROD] ([CD_CTR_AGENDA])
	INCLUDE ([CD_PROD])

/***********************************************************************************************/
-- Remove produtos que nao fazem parte do ressuprimento.

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Remove produtos que nao fazem parte do ressuprimento - EST_PROD_TRANSF_AGENDAS_PROD'
		,'DELETE'
		, 239
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

		DELETE FROM A 
		FROM 
			EST_PROD_TRANSF_AGENDAS_PROD A
			LEFT JOIN EST_PROD_TRANSF_PRODUTOS P ON 
			A.CD_PROD =P.CD_PROD
		WHERE	
			P.CD_PROD IS NULL  

/***********************************************************************************************/

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Carrega tabela auxiliar de agendamento - EST_PROD_TRANSF_AGENDAMENTO_AUX'
		,'INSERT'
		, 258
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

	INSERT INTO EST_PROD_TRANSF_AGENDAMENTO_AUX  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,AGD_DIARIO)
	SELECT   
		@CD_EMP CD_EMP,
		F.CD_FILIAL,
		P.CD_PROD, 
			(ISNULL((A.LEAD_TIME+ A.PARAM_EST),0) ) PARAM_ADICIONAL,
			(ISNULL(A.FLAG_NAO_ENVIAR_PBM,0))	   FLAG_NAO_ENVIAR_PBM,
			(ISNULL(A.AGD_DIARIO,0)) AGD_DIARIO
	FROM 
		EST_PROD_AGENDA_COMPRA A
		jOIN EST_PROD_TRANSF_AGENDAS_PROD P ON 
		A.CD_CTR_AGENDA = P.CD_CTR_AGENDA
		JOIN (SELECT DISTINCT
					A.CD_EMP,
					A.CD_CTR_AGENDA,
					COALESCE(F.CD_FILIAL, BF.CD_FILIAL, 0) CD_FILIAL
				FROM 
					EST_PROD_AGENDA_COMPRA A
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON 
					A.CD_CTR_AGENDA = B.CD_CTR_AGENDA
					LEFT JOIN PRC_BANDEIRA_PRC_FILIAL BF ON 
					B.CD_BANDEIRA = BF.CD_BANDEIRA
					AND BF.CD_EMP=1
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON 
					A.CD_CTR_AGENDA = F.CD_CTR_AGENDA
				WHERE
					A.TIPO_AGENDA= 2
					AND A.CD_EMP=@CD_EMP
					AND A.CD_FILIAL_DEPO = @CD_DEPOSITO) F ON  
		A.CD_CTR_AGENDA  = f.CD_CTR_AGENDA  

/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Carrega tabela de agendamento - EST_PROD_TRANSF_AGENDAMENTO'
		,'INSERT'
		, 299
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

	INSERT INTO EST_PROD_TRANSF_AGENDAMENTO  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,DIARIO)
	SELECT   
		A.CD_EMP,
		A.CD_FILIAL,
		A.CD_PROD, 
		MAX(A.PARAM_ADICIONAL) PARAM_ADICIONAL,
		MAX(A.FLAG_NAO_ENVIAR_PBM)	   FLAG_NAO_ENVIAR_PBM,
		MAX(A.AGD_DIARIO) AGD_DIARIO
	FROM 
		EST_PROD_TRANSF_AGENDAMENTO_AUX A
		LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO F ON
		A.CD_EMP	= F.CD_EMP	 AND
		A.CD_FILIAL = F.CD_FILIAL AND 
		A.CD_PROD	= F.CD_PROD
	WHERE  F.CD_PROD IS NULL
	GROUP BY 
		A.CD_EMP,
		A.CD_FILIAL,
		A.CD_PROD
/***********************************************************************************************/
--Curvas
/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Carrega agendamento de curvas - EST_PROD_AGENDA_COMPRA_EST_PROD_CURVA_SIGLA'
		,'INSERT'
		, 330
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');
	SELECT  DISTINCT 
		A.CD_EMP,
		F.CD_FILIAL,
		S.CD_SIGLA
		INTO #TMP_TBL_SIGLA
	FROM 
		EST_PROD_AGENDA_COMPRA A
		JOIN (SELECT DISTINCT
					A.CD_EMP,
					A.CD_CTR_AGENDA,
					COALESCE(F.CD_FILIAL, BF.CD_FILIAL, 0) CD_FILIAL
				FROM 
					EST_PROD_AGENDA_COMPRA A
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON 
					A.CD_CTR_AGENDA = B.CD_CTR_AGENDA
					LEFT JOIN PRC_BANDEIRA_PRC_FILIAL BF ON 
					B.CD_BANDEIRA = BF.CD_BANDEIRA
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON 
					A.CD_CTR_AGENDA = F.CD_CTR_AGENDA
				WHERE
					A.TIPO_AGENDA= 2
					AND A.CD_EMP=@CD_EMP
					AND A.CD_FILIAL_DEPO = @CD_DEPOSITO) F ON 
		A.CD_EMP		  = f.CD_EMP AND
		A.CD_CTR_AGENDA  = f.CD_CTR_AGENDA
		JOIN EST_PROD_AGENDA_COMPRA_EST_PROD_CURVA_SIGLA  S ON 
		A.CD_EMP			= S.CD_EMP AND
		A.CD_CTR_AGENDA		= S.CD_CTR_AGENDA
	WHERE
		A.TIPO_AGENDA= 2
		AND STS_AGENDA=0			
		AND A.CD_EMP=@CD_EMP
		AND A.CD_FILIAL_DEPO = @CD_DEPOSITO
		AND (CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
					WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
					WHEN @DIA_SEMANA =3 THEN A.TERCA  
					WHEN @DIA_SEMANA =4 THEN A.QUARTA
					WHEN @DIA_SEMANA =5 THEN A.QUINTA  
					WHEN @DIA_SEMANA =6 THEN A.SEXTA  
					WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1;

	IF EXISTS(SELECT * FROM #TMP_TBL_SIGLA)
	BEGIN
		DELETE FROM P 
		FROM 
			EST_PROD_TRANSF_MEDIAF_PARAMS P 
			LEFT JOIN #TMP_TBL_SIGLA S ON 
			P.CD_EMP	= S.CD_EMP AND 
			P.CD_FILIAL = S.CD_FILIAL AND 
			P.CD_SIGLA	= S.CD_SIGLA
		WHERE
			S.CD_EMP IS NULL;
	END  

/***********************************************************************************************/
-- Remove os produtos sem agendamento
/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Remove os produtos sem agendamento - EST_PROD_TRANSF_MEDIAF_PARAMS'
		,'DELETE'
		, 395
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');

	DELETE FROM P
	FROM	
		EST_PROD_TRANSF_MEDIAF_PARAMS P
		LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO A ON
		P.CD_EMP   = A.CD_EMP AND
		P.CD_FILIAL= A.CD_FILIAL AND
		P.CD_PROD  = A.CD_PROD
	WHERE
		A.CD_EMP IS NULL;  

	--Deletar dos produtos PBM
	IF EXISTS ( SELECT TOP 1 * FROM EST_PROD_TRANSF_AGENDAMENTO
		WHERE FLAG_NAO_ENVIAR_PBM =1)
		begin
			 DELETE FROM P
			 FROM	
			 	EST_PROD_TRANSF_MEDIAF_PARAMS P
			 	INNER JOIN EST_PROD_RC_CLI_CONV A ON
			 	P.CD_EMP   = A.CD_EMP AND
			 	P.CD_PROD  = A.CD_PROD
			 WHERE
			 	REPOSICAO='S'
		end 
/******************************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Atualiza os parametros adicionais de agenda - EST_PROD_TRANSF_MEDIAF_PARAMS'
		,'UPDATE'
		, 428
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO'); 

	UPDATE P
		SET
			EMAX =EMAX+A.PARAM_ADICIONAL,
			ConsideraEseg = case when A.DIARIO >4 then 1  --Se for agendamento diario vai considerar o Eseg..
							else 0 end 
		FROM	
			EST_PROD_TRANSF_MEDIAF_PARAMS P
			INNER JOIN EST_PROD_TRANSF_AGENDAMENTO A ON
			P.CD_EMP   = A.CD_EMP AND
			P.CD_FILIAL= A.CD_FILIAL AND
			P.CD_PROD  = A.CD_PROD
/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Fim da proc de agendamento - P_EST_PROD_TRANSF_AGENDAMENTO'
		,'INFORMACAO'
		, 449
		,'P_EST_PROD_TRANSF_AGENDAMENTO'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'RESSUPRIMENTO');
/***********************************************************************************************/